/*
 * @(#)DocumentAdapter.java  1.0  2001-07-24
 *
 * Copyright (c) 2001 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.gui.event;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
 * An abstract adapter class for receiving window events.
 * The methods in this class are empty. 
 * This class exists as convenience for creating listener objects.  
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, Immensee, CH-6405, Switzerland
 * @version 1.0 2001-07-24
 */
public class DocumentAdapter 
implements DocumentListener {

    /** Creates new DocumentAdapter */
    public DocumentAdapter(JTextComponent c) {
        c.getDocument().addDocumentListener(this);
        
    }

    /**
     * Gives notification that a portion of the document has been 
     * removed.  The range is given in terms of what the view last
     * saw (that is, before updating sticky positions).
     *
     * @param e the document event
     */
    public void removeUpdate(DocumentEvent evt) {
        documentChanged(evt);
    }
    
    /**
     * Gives notification that there was an insert into the document.  The 
     * range given by the DocumentEvent bounds the freshly inserted region.
     *
     * @param e the document event
     */
    public void insertUpdate(DocumentEvent evt) {
        documentChanged(evt);
    }
    
    /**
     * Gives notification that an attribute or set of attributes changed.
     *
     * @param e the document event
     */
    public void changedUpdate(DocumentEvent evt) {
        documentChanged(evt);
    }
    
    public void documentChanged(DocumentEvent evt) {
    }
    public String getText(DocumentEvent evt) {
        Document doc = evt.getDocument();
        String txt;
        try {
            txt = doc.getText(0, doc.getLength());
        } catch (BadLocationException e) {
            txt = null;
        }
        return txt;
    }
}
